// author: RuanShengQiang 
// date: 2017/6/1
#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw

const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;

vec4 INPUT(image2d_t src_data, __global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, (vec2)(tc.x, 1.0f - tc.y));
}

float _abs(float a)
{
	if(a<0.0f)
		return -a;
	else
		return a;
}

bool inBounds (vec2 p,vec2 resolution) {
  float xMax = resolution.x / resolution.y / 2.0f;
  vec2 temp1 = (vec2)(-xMax, -0.5f);
  vec2 temp2 = (vec2)(xMax, 0.5f);
  return temp1.x<p.x && temp1.y<p.y && p.x < temp2.x && p.y <temp2.y;
 // return all(lessThan((vec2)(-xMax, -0.5f), p)) && all(lessThan(p, (vec2)(xMax, 0.5f)));
}

__kernel void MAIN(__read_only image2d_t input1, __read_only image2d_t input2, __write_only image2d_t dstImg,__global FilterParam* param)
{
	//const sampler_t sampler = CLK_NORMALIZED_COORDS_FALSE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_NEAREST;
	
	float progress = param->cur_time / param->total_time;
	int W = get_global_size(0);
	int H = get_global_size(1);
	int textH = param->height[2];
	int w = get_global_id(0);
	int h = get_global_id(1);
	float2 resolution = (float2)(W,H);
	int2 gl_FragCoord = (int2)(get_global_id(0), get_global_id(1));
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	vec2 tc = ((vec2)(fragCoord.x, fragCoord.y) + (vec2)(0.5f)) /resolution.xy;
	
	float4 gl_FragColor = (vec4)(0.0f);
	float y = tc.y;  
	float alpha = 0.0f;
	vec2 p;
	vec4 f,t;
  
	f = INPUT(input1, param,tc);
  	t = INPUT(input2, param,tc);
  
	alpha = step(0.5f,progress);  
	y = _abs(y - 0.5f);
  	progress = min(progress, 1.0f - progress);  
	if(y < progress) 
	{
	 alpha = y * 2.0f;
	}
	write_imagef(dstImg, (int2)(w, textH - h -1), mix(f, t, alpha));
}